<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RestaurantReview extends Model 
{

    protected $table = 'restaurant_reviews';
    public $timestamps = true;
    protected $fillable = array('packaging', 'money', 'delivery_time', 'quality_of_food', 'restaurant_id', 'client_id');

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function restaurant()
    {
        return $this->belongsTo('App\Models\Restaurant');
    }

}